<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace app\commands;

use common\api\models\XML\IOCore;
use common\api\models\XML\Project;
use yii\console\Controller;
use yii\helpers\Console;

class BridgeController extends Controller
{

    public function actionIndex()
    {

    }

/*
    public function actionMakeFeed($feed)
    {
        try {
            $structure = $feed;
            $exportC = [$structure];

            \common\api\models\XML\IOCore::get()->setAttachmentMode(['attach_file', 'file_info', 'url', 'checksum_md5', 'checksum_sha1']);

            foreach ($exportC as $structure) {
                $exportToFile = 'xml/' . $structure . '.xml';
                //$exportToFile = 'php://output';
                $IOProject = new \common\api\models\XML\Project($exportToFile);
                $IOProject->setStructure(\common\api\models\XML\IOCore::getExportStructure($structure));

                $IOProject->export();

                if (count($exportC) == 1) {
                    if ($exportToFile != 'php://output') {
                        readfile($exportToFile);
                    }
                } else {
                    echo '<pre>';
                    var_dump($structure, filesize($exportToFile));
                    echo '</pre>';
                }
            }
        } catch (\Exception $ex) {
            echo '<pre>';
            var_dump($ex->getMessage(), $ex->getTraceAsString());
            echo '</pre>';
        }
    }

    public function actionImportFeed($feedFile)
    {
        IOCore::get();
        $IOProject = new Project($feedFile);
        $detectedStructure = $IOProject->detectStructure();
        if ($detectedStructure) {
            Console::output("Detected [{$detectedStructure}]");
            $IOProject->setStructure(\common\api\models\XML\IOCore::getExportStructure($detectedStructure));
            $IOProject->import();
        } else {
            Console::error('Feed type not detected');
        }
    }
*/
    private function showVersion()
    {
        if (defined('OSCB_VER')) {
            Console::output("OSC bridge ver. ".OSCB_VER."\n");
        }
    }

    public function actionShowSecureKey()
    {
        \common\helpers\Init::IOInit();
        $this->showVersion();

        $codes = \common\helpers\Init::getCurrentSecureKeyCheck();
        Console::output("SecureKey(s):\n {$codes}");
    }

    public function actionDropAllKeys()
    {
        $this->showVersion();
        \common\helpers\Init::deleteAllProjects();
        Console::output("Done.");
    }

}