<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\api\models\XML;


abstract class Complex{

    protected $named;
    public $table;
    public $attribute;
    public $value;

    public function getMapName()
    {
        return !empty($this->named)?$this->named:($this->table.'.'.$this->attribute);
    }

    public function setMap($table, $attribute)
    {
        $this->table = $table;
        $this->attribute = $attribute;
    }

    public function serializeTo(\SimpleXMLElement $parent)
    {

    }

    static public function restoreFrom(\SimpleXMLElement $node, $obj)
    {
        return strval($node);
    }

    public function toImportModel()
    {
        return $this->value;
    }

}