<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\api\models\XML;


class IOLanguageMap extends IOMap
{
    protected $named = '@language';
    public $language;

    public function serializeTo(\SimpleXMLElement $parent)
    {
        if ( !empty($this->value) ) {
            $parent->addAttribute('language', \common\classes\language::get_code($this->value));
            $parent->addAttribute('internalId', $this->value);
            $externalId = IOCore::get()->getAttributeMapper()->externalId($this);
            if ( is_numeric($externalId) ) {
                $parent->addAttribute('externalId', $externalId);
            }
        }
    }

    public function toImportModel()
    {
        $parentResult = parent::toImportModel();

        if ( !$parentResult && !empty($this->language) && !IOCore::get()->isLocalProject() ) {
            $newId = \common\classes\language::get_id($this->language);
            if ( $newId ) {
                $this->internalId = $newId;
                $this->value = $newId;
                $parentResult = $newId;
                IOCore::get()->getAttributeMapper()->mapIds($this, $this->internalId, $this->externalId);
            }
        }

        return $parentResult;
    }
}