<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\api\models\XML;


class IOLookup
{
    public function lookupOrderStatus($statusName, $createMissing=false)
    {
        $getSameName_r = tep_db_query(
            "SELECT orders_status_id ".
            "FROM ".TABLE_ORDERS_STATUS." ".
            "WHERE orders_status_name='".tep_db_input($statusName)."' ".
            "ORDER BY orders_status_id ".
            "LIMIT 1 "
        );
        if ( tep_db_num_rows($getSameName_r)>0 ) {
            $statusIdArray = tep_db_fetch_array($getSameName_r);
            return $statusIdArray['orders_status_id'];
        }

        if ( $createMissing ) {
            $get_new_order_status_id_arr = tep_db_fetch_array(tep_db_query(
                "SELECT MAX(orders_status_id) AS current_max_id FROM ".TABLE_ORDERS_STATUS
            ));
            $new_order_status_id = intval($get_new_order_status_id_arr['current_max_id'])+1;
            tep_db_query(
                "INSERT INTO ".TABLE_ORDERS_STATUS." ".
                "(orders_status_id, language_id, orders_status_name ) ".
                "SELECT {$new_order_status_id}, languages_id, '".tep_db_input($statusName)."' FROM ".TABLE_LANGUAGES
            );

            return $new_order_status_id;
        }
        return 0;
    }
}