<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\api\models\XML;


class IOMap extends Complex
{
    public $internalId;
    public $externalId;

    public function serializeTo(\SimpleXMLElement $parent)
    {
        $parent->addAttribute('internalId', $this->value);
        $externalId = IOCore::get()->getAttributeMapper()->externalId($this);
        if ( is_numeric($externalId) ) {
            $parent->addAttribute('externalId', $externalId);
        }
    }

    static public function restoreFrom(\SimpleXMLElement $node, $obj)
    {
        if ( !is_object($obj) || !($obj instanceof Complex) ) {
            $obj = new self();
        }
        $objProperties = \Yii::getObjectVars($obj);
        foreach ($node->attributes() as $attrName=>$attrValue){
            if ( array_key_exists($attrName,$objProperties) ) {
                $obj->{$attrName} = strval($attrValue);
            }
        }

        if ( empty($obj->internalId) && empty($obj->externalId) && trim($node)!='' ) {
            // imported XML without type : <tag>value</tag>
            $obj->internalId = trim($node);
        }

        if ( $obj->internalId ){
            $obj->internalId = intval($obj->internalId);
        }
        if ( $obj->externalId ){
            $obj->externalId = intval($obj->externalId);
        }

        if ( !IOCore::get()->isLocalProject() ) {
            $externalId = $obj->externalId;
            $obj->externalId = $obj->internalId;
            $obj->internalId = $externalId;
        }
        //if ( is_numeric($map->internalId) ) {
        $obj->value = $obj->internalId;
        //}else{

        //}
        return $obj;
    }

    public function isMapValid()
    {

    }

    public function toImportModel()
    {
        if ( !IOCore::get()->isLocalProject() && empty($this->internalId) && !empty($this->externalId) ) {
            $mappedId = IOCore::get()->getAttributeMapper()->internalId($this);
            if ( $mappedId ) {
                $this->internalId = $mappedId;
                $this->value = $mappedId;
            }
        }
        return $this->value;
    }

    public function afterImportModel($value)
    {
        if ( !empty($this->externalId) && !IOCore::get()->isLocalProject() ) {
            IOCore::get()->getAttributeMapper()->mapIds($this, $value, $this->externalId);
        }
        //echo '<pre>afterImportModel '; var_dump($this->table, $this->attribute, $value); echo '</pre>';
    }
}