<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\api\models\XML;


class IOOrderStatus extends IOMap
{
    protected $named = '@order_status';
    public $name;

    public function serializeTo(\SimpleXMLElement $parent)
    {
        parent::serializeTo($parent);

        static $statuses = [];
        if ( $this->value && !isset($statuses[$this->value]) ) {
            $statuses[$this->value] = \common\helpers\Order::get_order_status_name($this->value, \common\helpers\Language::get_default_language_id());
        }
        if ( isset($statuses[$this->value]) ) {
            $parent->addAttribute('name', $statuses[$this->value]);
        }
    }

    public function toImportModel()
    {
        $parentResult = parent::toImportModel();

        if ( !$parentResult && !empty($this->name) && !IOCore::get()->isLocalProject() ) {
            // unknown import status id
            $newStatusId = IOCore::get()->getLookupTool()->lookupOrderStatus($this->name, true);
            if ( $newStatusId ) {
                $this->internalId = $newStatusId;
                $this->value = $newStatusId;
                $parentResult = $newStatusId;
                IOCore::get()->getAttributeMapper()->mapIds($this, $this->internalId, $this->externalId);
            }
        }

        return $parentResult;
    }


}