<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\api\models\XML;


class IOPK extends IOMap
{
    public function serializeTo(\SimpleXMLElement $parent)
    {
        $parent->addAttribute('internalId', $this->value);
        $externalId = IOCore::get()->getAttributeMapper()->externalId($this);
        if ( is_numeric($externalId) ) {
            $parent->addAttribute('externalId', $externalId);
        }
    }

    static public function restoreFrom(\SimpleXMLElement $node, $obj)
    {
        if ( !is_object($obj) || !($obj instanceof Complex) ) {
            $obj = new self();
        }
        return parent::restoreFrom($node, $obj); // TODO: Change the autogenerated stub
    }

}