<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\api\models\XML;


class IOPlatformMap extends Complex
{
    protected $name = '@platform';

    public function serializeTo(\SimpleXMLElement $parent)
    {
        if ( !empty($this->value) ) {
            $parent->addAttribute('internalId', $this->value);
            $externalId = IOCore::get()->getAttributeMapper()->externalId($this);
            if ( is_numeric($externalId) ) {
                $parent->addAttribute('externalId', $externalId);
            }
        }
    }
}