<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\api\models\XML;

class Project
{

    protected $structure;
    /**
     * @var RelatedSerialize
     */
    protected $Serializer;

    protected $offset, $limit;

    /**
     * IOProject constructor.
     * @param string $fileName
     */
    public function __construct($fileName)
    {
        $this->fileName = $fileName;
        $this->Serializer = new RelatedSerialize();
        static::checkLocalProjects();
    }

    public static function checkLocalProjects()
    {
        $checkPrimaryProject = tep_db_fetch_array(tep_db_query(
            "SELECT COUNT(*) AS c FROM io_project WHERE is_local=1 AND department_id=0 AND platform_id=0"
        ));
        if ( $checkPrimaryProject['c']==0 ) {
            $project_code = static::allocateCode(\common\helpers\Init::getPrefixFull());
            static::createProject($project_code, [
                'is_local' => 1,
                'department_id' => 0,
                'platform_id' => 0,
            ]);
        }
    }

    public static function allocateCode($prefix)
    {
        do {
            $getServerUuid = tep_db_fetch_array(tep_db_query("SELECT HEX(UUID_SHORT()) AS short_u"));
            $prefixT = substr(strtoupper(preg_replace('/[^\da-z]/i', '', $prefix)), 0, 8) . '_' .$getServerUuid['short_u'] . date('ymd');
            $checkUniq = tep_db_fetch_array(tep_db_query(
                "SELECT COUNT(*) AS c FROM io_project WHERE project_code='".tep_db_input($prefixT)."'"
            ));
        }while($checkUniq['c']>0);

        return $prefixT;
    }


    public static function createProject($projectCode, $extraData)
    {
        $data = array(
            'project_code' => $projectCode,
            'access_token' => \common\helpers\Init::generateToken(),
        );
        if ( is_array($extraData) ) {
            $data = array_merge($data, $extraData);
        }
        tep_db_perform('io_project', $data);
        return tep_db_insert_id();
    }

    public function setStructure($structure)
    {
        $this->structure = $structure;
        $this->Serializer->setConfigureMap($this->structure);
    }

    public function setPage($offset, $limit)
    {
        $this->offset = $offset;
        $this->limit = $limit;
    }

    private function applyPage()
    {
        if (is_array($this->structure['Data'])) {
            foreach($this->structure['Data'] as $key=>$value) {
                if ($this->offset >= 0) {
                    $this->structure['Data'][$key]['offset'] = $this->offset;
                }
                if ($this->limit >= 1) {
                    $this->structure['Data'][$key]['limit'] = $this->limit;
                }
            }
        }
        $this->Serializer->setConfigureMap($this->structure);
    }

    public function detectStructure()
    {
        $detectedStructure = false;
        $xmlParser = new XMLtoArrayParser();
        $xmlParser->parseFile($this->fileName);
        $xmlParser->setCollectPath('/data/Header');
        $xmlHeader = $xmlParser->read();

        if ( is_array($xmlHeader) && !empty($xmlHeader['type']) ) {
            foreach (glob(dirname(__FILE__).'/structure/*.php') as $structureFile){
                $testArray = include($structureFile);
                if ( is_array($testArray) && isset($testArray['Header']) ) {
                    $checkHeader = $testArray['Header'];
                    if ( !is_array($checkHeader) ) $checkHeader = array('type'=>$checkHeader);
                    if ( $checkHeader['type'] == $xmlHeader['type'] ) {
                        $detectedStructure = pathinfo($structureFile, PATHINFO_FILENAME);
                        break;
                    }
                }
            }
        }

        return $detectedStructure;
    }

    public function export()
    {
        $this->applyPage();
        $writer = new XMLWriter($this->fileName);
        if ( isset($this->structure['XSL']) && is_array($this->structure['XSL']) && !empty($this->structure['XSL']['export']) ) {
            if ( is_file($this->structure['XSL']['export']) ) {
                $writer->applyXSLT($this->structure['XSL']['export']);
            }
        }
        $this->Serializer->export($writer);
    }

    public function import()
    {
        $this->Serializer->import($this->fileName);
    }

}