<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

return [
    'Header' => 'site/brands',
    'dependsOn' => ['site/languages'],
    'Data' => [
        'common\\api\\models\\AR\\Manufacturer' => [
            'xmlCollection' => 'Brands>Brand',
            'properties' => [
                'manufacturers_image' => ['class'=>'IOAttachment', 'location'=>'@images'],
            ],
            'withRelated' => [
                'infos' => [
                    'xmlCollection' => 'InformationArray>Information',
                    'properties' => [
                        'languages_id' => ['class' => 'IOLanguageMap'],
                    ],
                ],
            ],
        ],
    ],
    'covered_tables' => ['manufacturers','manufacturers_info',],
];

