<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

return [
    'Header' => 'site/categories',
    'Data' => [
        'common\\models\\Categories' => [
            'orderBy' => ['parent_id' => 'ASC', 'categories_id' => 'ASC'],
            'xmlCollection' => 'Categories>Category',
            'properties' => [
                'parent_id' => ['class'=>'IOMap', 'table'=>'categories', 'attribute' => 'categories_id'],
                'categories_level' => false,
                'categories_left' => false,
                'categories_right' => false,
                'categories_image' => ['class'=>'IOAttachment', 'location'=>'@images'],
                'categories_image_2' => ['class'=>'IOAttachment', 'location'=>'@images'],
            ],
            'withRelated' => [
                'descriptions' => [
                    //'where' => ['affiliate_id'=>0],
                    'xmlCollection' => 'Descriptions>Description',
                    'properties' => [
                        'language_id' => ['class' => 'IOLanguageMap'],
                    ],
                    'hideProperties' => [
                        'affiliate_id',
                    ],
                ],
/*
                'platform' => [
                    'xmlCollection' => 'AssignedPlatforms>AssignedPlatform',
                ],
                'seoRedirectsNamed' => [
                    'xmlCollection' => 'SeoRedirects>SeoRedirect',
                    'properties' => [
                        'seo_redirects_named_id' => false,
                        'language_id' => ['class' => 'IOLanguageMap'],
                        'redirects_type' => false,
                    ],
                ],
*/
            ],
            'afterImport' => function($model, $data){
                \common\helpers\Categories::update_categories();
            },
        ],
    ],
    'covered_tables' => ['categories', 'categories_description', 'platforms_categories'],
];