<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

return [
    'Header' => [
        'type' => 'site/customers',
        //'version' => '1.0',
    ],
    'dependsOn' => ['site/languages', 'site/currencies', 'site/platforms', 'site/countries'],
    'Data' => [
        'common\\models\\Customers' => [
            'xmlCollection' => 'Customers>Customer',
            //'where' => ['affiliate_id'=>'0'],
            'afterImport' => function($model, $data){
                if ( isset($data->data['customers_default_address_id']) && is_object($data->data['customers_default_address_id']) ) {
                    $defAbId = $data->data['customers_default_address_id']->toImportModel();
                    if ( $defAbId ) {
                        $model->customers_default_address_id = $defAbId;
                        $model->save(false);
                    }
                }
            },
            'properties' => [
                'customers_default_address_id' => ['class'=>'IOMap', 'table'=>'address_book','attribute'=>'address_book_id'],
                'groups_id' => ['class'=>'IOMap', 'table'=>'groups','attribute'=>'groups_id'],
                'customers_currency_id' => ['class' => 'IOCurrencyMap'],
                'platform_id' => ['class' => 'IOPlatformMap']
            ],
            'withRelated' => [
                'addressBooks' => [
                    'xmlCollection' => 'AddressBooks>AddressBook',
                    'properties' => [
                        //'groups_discounts_id' => false,
                        'entry_country_id' => ['class' => 'IOCountryMap'],
                    ],
                ],
/*                'customersEmails' => [
                    'xmlCollection' => 'CustomersEmails>CustomersEmail',
                ],
                'customersPhones' => [
                    'xmlCollection' => 'CustomersPhones>CustomersPhone',
                ],*/
                'customersInfo' => [
                    'xmlCollection' => 'CustomersInfo>Data',
                ],
            ],
        ],
    ],
    'covered_tables' => ['customers','address_book','customers_emails', 'customers_phones', 'customers_info'],
];