<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

return array(
    'Header' => [
        'type' => 'site/orders',
    ],
    'dependsOn' => ['site/languages', 'site/order_statuses', 'site/currencies', 'site/platforms', 'site/customers', 'site/products', 'site/countries'],
    'Data' => array(
        'common\\models\\Orders' => array(
            //'where'=>['AND', ['<=', 'orders_id', '124085']],
            'orderBy' => ['orders_id'=>'ASC'],
            'xmlCollection' => 'Orders>Order',
            'properties' => [
                'customers_id' => ['class'=>'IOMap', 'table'=>'customers','attribute'=>'customers_id'],
                'orders_status' => ['class'=>'IOOrderStatus'],
                'language_id' => ['class'=>'IOLanguageMap'],
            ],
            'beforeImportSave' => function($model, $data){
                if ( !\common\api\models\XML\IOCore::get()->isLocalProject() && $data->data['orders_id']->externalId ) {
                    $model->external_orders_id = $data->data['orders_id']->externalId;
                }
            },
            'withRelated' => array(
                'ordersProducts' => array(
                    'xmlCollection' => 'OrdersProducts>OrdersProduct',
                    'properties' => [
                        // 'orders_products_id'=>false,
                    ],
                    'withRelated' => array(
                        'ordersProductsAttributes' => array(
                            'xmlCollection' => 'Attributes>Attribute',
                            'properties' => [
                                // 'orders_products_attributes_id'=>false,
                            ],
                        )
                    ),
                ),
                'ordersTotals' => array(
                    'xmlCollection' => 'OrdersTotals>OrdersTotal',
                    'properties' => [
                        // 'orders_total_id'=>false,
                    ],
                ),
                'ordersStatusHistory' => array(
                    'xmlCollection' => 'OrdersStatusHistory>OrdersStatus',
                    'properties' => [
                        // 'orders_status_history_id' => false, //???
                        'orders_status_id' => ['class'=>'IOOrderStatus'],
                    ]
                )
            ),
        ),
    ),
    'covered_tables' => array('orders', 'orders_products', 'orders_products_attributes', 'orders_total', 'orders_status_history'),
);