<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

return [
    'Header' => 'site/products',
    'dependsOn' => ['site/languages', 'site/groups', 'site/currencies'],
    'Data' => [
        'common\\models\\Products' => [
            // 'where' => ['products_id'=>8837],
            'xmlCollection' => 'Products>Product',
            'properties' => [
                'products_image' => ['class'=>'IOAttachment', 'location'=>'@images'],
                'products_image_lrg' => ['class'=>'IOAttachment', 'location'=>'@images'],
                'products_image_sm_1' => ['class'=>'IOAttachment', 'location'=>'@images'],
                'products_image_xl_1' => ['class'=>'IOAttachment', 'location'=>'@images'],
                'products_image_sm_2' => ['class'=>'IOAttachment', 'location'=>'@images'],
                'products_image_xl_2' => ['class'=>'IOAttachment', 'location'=>'@images'],
                'products_image_sm_3' => ['class'=>'IOAttachment', 'location'=>'@images'],
                'products_image_xl_3' => ['class'=>'IOAttachment', 'location'=>'@images'],
                'products_image_sm_4' => ['class'=>'IOAttachment', 'location'=>'@images'],
                'products_image_xl_4' => ['class'=>'IOAttachment', 'location'=>'@images'],
                'products_image_sm_5' => ['class'=>'IOAttachment', 'location'=>'@images'],
                'products_image_xl_5' => ['class'=>'IOAttachment', 'location'=>'@images'],
                'products_image_sm_6' => ['class'=>'IOAttachment', 'location'=>'@images'],
                'products_image_xl_6' => ['class'=>'IOAttachment', 'location'=>'@images'],
            ],
            'hideProperties' => [
                'vendor_id',
                'products_image_med',
                'last_xml_import',
                'last_xml_export',
            ],
            'withRelated' => [
                'descriptions' => [
                    //'where' => ['affiliate_id'=>0],
                    'xmlCollection' => 'Descriptions>Description',
                    'properties' => [
                        'language_id' => ['class' => 'IOLanguageMap'],
                        'products_name_soundex' => false,
                        'products_description_soundex' => false,
                    ],
                ],
                /*
                'platform' => [
                    'xmlCollection' => 'AssignedPlatforms>AssignedPlatform',
                ],
                */
                'categoriesList' => [
                    'xmlCollection' => 'AssignedCategories>AssignedCategory',
                ],
                /*
                'productsPrices' => [
                    'xmlCollection' => 'Prices>Price',
                    'properties' => [
                        'groups_id' => ['class'=>'IOMap', 'table'=>'groups','attribute'=>'groups_id'],
                        'currencies_id' => ['class'=>'IOCurrencyMap'],
                    ],
                ],
                */
                'productsAttributes' => [
                    'xmlCollection' => 'Attributes>Attribute',
                ],
                'productImagesList' => [
                    'xmlCollection' => 'ImagesList>Image',
                    'properties' => [
                        'image' => ['class'=>'IOAttachment', 'location'=>'@images'],
                    ],
                ],
                /*
                'inventories' => [
                    'xmlCollection' => 'Inventories>Inventory',
                ],
                'productsFeatured' => [
                    'xmlCollection' => 'Featured>FeaturedInfo',
                    'where' => ['status'=>'1'],
                    'properties' => [
                        'featured_id' => false,
                        'featured_last_modified' => false,
                        'date_status_change' => false,
                        'status' => false,
                    ],
                ],
                */
            ],
        ],
    ],
    'covered_tables' => [ 'products', 'products_description', 'platforms_products', 'products_to_categories', 'products_images', 'products_images_description' ],
];