<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

return [
    'Header' => 'site/reviews',
    'dependsOn' => ['site/products', 'site/customers'],
    'Data' => [
        'common\\models\\Reviews' => [
            'xmlCollection' => 'Reviews>Review',
            'properties' => [
                'products_id' => ['class'=>'IOMap', 'table'=>'products', 'attribute'=>'products_id'],
                'customers_id' => ['class'=>'IOMap', 'table'=>'customers', 'attribute'=>'customers_id'],
            ],
            'withRelated' => [
                'descriptions' => [
                    'xmlCollection' => 'Descriptions>Description',
                    'properties' => [
                        'languages_id' => ['class' => 'IOLanguageMap'],
                    ],
                ],
            ],
         ]
    ],
    'covered_tables' => [ 'reviews', 'reviews_description', ],
];
