<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

return [
    'Header' => 'site/tax_zones',
    'dependsOn' => ['site/countries'],
    'Data' => [
        'common\\models\\TaxZones' => [
            'xmlCollection' => 'TaxZones>TaxZone',
            'withRelated' => [
                'zoneZones' => [
                    'xmlCollection' => 'Zones>Zone',
                    'properties' => [
                        'association_id' => false,
                        'zone_country_id' => ['class'=>'IOCountryMap'],
                        'zone_id' => ['class'=>'IOCountryZoneMap'],
                    ],
                ],
            ],
        ]
    ],
    'covered_tables' => [ 'tax_zones', 'zones_to_tax_zones' ],
];
