<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

return [
    'Header' => 'site/taxes',
    'dependsOn' => ['site/tax_zones'],
    'Data' => [
        'common\\models\\TaxClass' => [
            'xmlCollection' => 'TaxClasses>TaxClass',
            'withRelated' => [
                'taxRateList' => [
                    'xmlCollection' => 'TaxRates>TaxRate',
                    'properties' =>[
                        'tax_zone_id' => ['class'=>'IOMap', 'table'=>'tax_zones', 'attribute'=>'geo_zone_id'],
                    ]
                ],
            ],
         ]
    ],
    'covered_tables' => [ 'tax_class', 'tax_rates', ],
];
