<?php
namespace common\classes;

////
// Class to handle currencies
// TABLES: currencies
  class currencies {
    var $currencies;

// class constructor
    function __construct() {
      $this->currencies = array();
      $currencies_query = tep_db_query(
        "select currencies_id, code, title, symbol_left, symbol_right, decimal_point, thousands_point, decimal_places, value, ".
        "round_up, ".
        "disable_in_store ".
        "from " . TABLE_CURRENCIES
      );
      while ($currencies = tep_db_fetch_array($currencies_query)) {
        /*
        if ( defined('AFFILIATE_REGION_ID') ){
          if ( strpos($currencies['disable_in_store'], ','.(int)AFFILIATE_REGION_ID.',')!==false ) {
            // disabled
            continue;
          }
        }else
        if ( strpos($currencies['disable_in_store'], ','.(int)AFFILIATE_ID.',')!==false){
          // disabled
          continue;
        }
        */

        $this->currencies[$currencies['code']] = array('title' => $currencies['title'],
                                                       'id' => $currencies['currencies_id'],
                                                       'code' => $currencies['code'],
                                                       'symbol_left' => $currencies['symbol_left'],
                                                       'symbol_right' => $currencies['symbol_right'],
                                                       'decimal_point' => $currencies['decimal_point'],
                                                       'thousands_point' => $currencies['thousands_point'],
                                                       'decimal_places' => $currencies['decimal_places'],
                                                       'round_up' => $currencies['round_up'],
                                                       'value' => $currencies['value']);
      }
    }

// class methods
    function format($number, $calculate_currency_value = true, $currency_type = '', $currency_value = '') {
      global $currency;

      if (empty($currency_type)) $currency_type = $currency;

      if ($calculate_currency_value == true && USE_MARKET_PRICES != 'True') {
        $rate = (tep_not_null($currency_value)) ? $currency_value : $this->currencies[$currency_type]['value'];
        $format_string = $this->currencies[$currency_type]['symbol_left'] . number_format(tep_round($number * $rate, $this->currencies[$currency_type]['decimal_places']), $this->currencies[$currency_type]['decimal_places'], $this->currencies[$currency_type]['decimal_point'], $this->currencies[$currency_type]['thousands_point']) . $this->currencies[$currency_type]['symbol_right'];
// if the selected currency is in the european euro-conversion and the default currency is euro,
// the currency will displayed in the national currency and euro currency
        if ( (DEFAULT_CURRENCY == 'EUR') && ($currency_type == 'DEM' || $currency_type == 'BEF' || $currency_type == 'LUF' || $currency_type == 'ESP' || $currency_type == 'FRF' || $currency_type == 'IEP' || $currency_type == 'ITL' || $currency_type == 'NLG' || $currency_type == 'ATS' || $currency_type == 'PTE' || $currency_type == 'FIM' || $currency_type == 'GRD') ) {
          $format_string .= ' <small>[' . $this->format($number, true, 'EUR') . ']</small>';
        }
      } else {
        $format_string = $this->currencies[$currency_type]['symbol_left'] . number_format(tep_round($number, $this->currencies[$currency_type]['decimal_places']), $this->currencies[$currency_type]['decimal_places'], $this->currencies[$currency_type]['decimal_point'], $this->currencies[$currency_type]['thousands_point']) . $this->currencies[$currency_type]['symbol_right'];
      }

// BOF: WebMakers.com Added: Down for Maintenance
      if (DOWN_FOR_MAINTENANCE=='true' && DOWN_FOR_MAINTENANCE_PRICES_OFF=='true') {
        $format_string= '';
      }
// BOF: WebMakers.com Added: Down for Maintenance

        return $format_string;
    }
    
    function format_clear($number, $calculate_currency_value = true, $currency_type = '', $currency_value = '') {
      global $currency;

      if (empty($currency_type)) $currency_type = $currency;

      if ($calculate_currency_value == true && USE_MARKET_PRICES != 'True') {
        $rate = (tep_not_null($currency_value)) ? $currency_value : $this->currencies[$currency_type]['value'];
        $format_string = number_format(tep_round($number * $rate, $this->currencies[$currency_type]['decimal_places']), $this->currencies[$currency_type]['decimal_places'], $this->currencies[$currency_type]['decimal_point'], ''/*$this->currencies[$currency_type]['thousands_point']*/);
// if the selected currency is in the european euro-conversion and the default currency is euro,
// the currency will displayed in the national currency and euro currency
        if ( (DEFAULT_CURRENCY == 'EUR') && ($currency_type == 'DEM' || $currency_type == 'BEF' || $currency_type == 'LUF' || $currency_type == 'ESP' || $currency_type == 'FRF' || $currency_type == 'IEP' || $currency_type == 'ITL' || $currency_type == 'NLG' || $currency_type == 'ATS' || $currency_type == 'PTE' || $currency_type == 'FIM' || $currency_type == 'GRD') ) {
          $format_string = $this->format_clear($number, true, 'EUR');
        }
      } else {
        $format_string = number_format(tep_round($number, $this->currencies[$currency_type]['decimal_places']), $this->currencies[$currency_type]['decimal_places'], $this->currencies[$currency_type]['decimal_point'], ''/*$this->currencies[$currency_type]['thousands_point']*/);
      }

// BOF: WebMakers.com Added: Down for Maintenance
      if (DOWN_FOR_MAINTENANCE=='true' && DOWN_FOR_MAINTENANCE_PRICES_OFF=='true') {
        $format_string= '';
      }
// BOF: WebMakers.com Added: Down for Maintenance

        return $format_string;
    }    

    function is_set($code) {
      if (isset($this->currencies[$code]) && tep_not_null($this->currencies[$code])) {
        return true;
      } else {
        return false;
      }
    }

    function get_value($code) {
      return $this->currencies[$code]['value'];
    }

    function get_decimal_places($code) {
      return $this->currencies[$code]['decimal_places'];
    }

    function display_price($products_price, $products_tax, $quantity = 1) {
      if ($products_price === false){
        return '';
      }else{
        if ( DISPLAY_PRICE_WITH_TAX == 'true' ) {
          return $this->format(tep_add_tax($products_price * $quantity, $products_tax));
        }else {
          return $this->format(tep_add_tax($products_price, $products_tax) * $quantity);
        }
      }
    }

    function display_price_2($products_price, $products_tax, $quantity = 1) {
      global $currency;
      if ($products_price === false){
        return '';
      }else{
        if ( DISPLAY_PRICE_WITH_TAX == 'true' ) {
          $number = tep_add_tax($products_price * $quantity, $products_tax);
        }else{
          $number = tep_add_tax($products_price, $products_tax) * $quantity;
        }
        if (USE_MARKET_PRICES != 'True') {
          $rate = $this->currencies[$currency]['value'];
          $format_string = number_format(
              tep_round($number * $rate, $this->currencies[$currency]['decimal_places']),
              $this->currencies[$currency]['decimal_places'],
              $this->currencies[$currency]['decimal_point'],
              $this->currencies[$currency]['thousands_point']
          );
        } else {
          $format_string = number_format(
            tep_round($number, $this->currencies[$currency]['decimal_places']),
            $this->currencies[$currency]['decimal_places'],
            $this->currencies[$currency]['decimal_point'],
            $this->currencies[$currency]['thousands_point']
          );
        }

        return $format_string;
      }
    }
  }
?>
