<?php

/**
 * This file is part of True Loaded.
 * 
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 * 
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\classes;

class language {

    var $languages, $catalog_languages, $browser_languages, $language;
    var $paltform_languages;
    var $dp_language;

    function __construct($lng = '') {
        $this->languages = array('ar' => 'ar([-_][a-zA-Z]{2})?|arabic',
            'bg' => 'bg|bulgarian',
            'br' => 'pt[-_]br|brazilian portuguese',
            'ca' => 'ca|catalan',
            'cs' => 'cs|czech',
            'da' => 'da|danish',
            'de' => 'de([-_][a-zA-Z]{2})?|german',
            'el' => 'el|greek',
            'en' => 'en([-_][a-zA-Z]{2})?|english',
            'es' => 'es([-_][a-zA-Z]{2})?|spanish',
            'et' => 'et|estonian',
            'fi' => 'fi|finnish',
            'fr' => 'fr([-_][a-zA-Z]{2})?|french',
            'gl' => 'gl|galician',
            'he' => 'he|hebrew',
            'hu' => 'hu|hungarian',
            'id' => 'id|indonesian',
            'it' => 'it|italian',
            'ja' => 'ja|japanese',
            'ko' => 'ko|korean',
            'ka' => 'ka|georgian',
            'lt' => 'lt|lithuanian',
            'lv' => 'lv|latvian',
            'nl' => 'nl([-_][a-zA-Z]{2})?|dutch',
            'no' => 'no|norwegian',
            'pl' => 'pl|polish',
            'pt' => 'pt([-_][a-zA-Z]{2})?|portuguese',
            'ro' => 'ro|romanian',
            'ru' => 'ru|russian',
            'sk' => 'sk|slovak',
            'sr' => 'sr|serbian',
            'sv' => 'sv|swedish',
            'th' => 'th|thai',
            'tr' => 'tr|turkish',
            'uk' => 'uk|ukrainian',
            'tw' => 'zh[-_]tw|chinese traditional',
            'zh' => 'zh|chinese simplified');

        $this->catalog_languages = array();
        $this->catalog_languages = self::get_all();

        $this->browser_languages = '';
        $this->language = '';

        $this->set_language($lng);
    }

    public static function get_all() {
        static $languages = false;
        if (!is_array($languages)) {
            $languages = array();
            $languages_query = tep_db_query("select * from " . TABLE_LANGUAGES . " /*where languages_status = 1*/ order by sort_order");
            while ($language = tep_db_fetch_array($languages_query)) {
                $languages[strtolower($language['code'])] = array(
                    'id' => $language['languages_id'],
                    'code' => strtolower($language['code']),
                    'name' => $language['name'],
                    'image' => $language['image'],
                    //'image_svg' => $language['image_svg'],
                    'directory' => $language['directory'],
                    //'locale' => $language['locale'],
                );
            }
        }
        return $languages;
    }

    function set_language($language, $update = false) {
        $this->language = $this->catalog_languages[strtolower(DEFAULT_LANGUAGE)];
    }

    function get_browser_language() {}

    function set_locale() {}

    function load_vars() {}

    public static function defaultId() {
        return self::get_id(DEFAULT_LANGUAGE);
    }

    public static function get_id($for_language=null) {
      global $language_id;
      if ( !empty($for_language) ) {
        foreach( self::get_all() as $_info ) {
          if ( is_numeric($for_language) && (int)$_info['id']==(int)$for_language ) {
            $language_id = $_info['id'];
            break;
          }elseif( !is_numeric($for_language) && ($_info['code']==$for_language || $_info['directory']==$for_language) ) {
            $language_id = $_info['id'];
            break;
          }
        }
      }
      return $language_id;
    }

    public static function get_code($for_language = null, $strict=false) {
        global $languages_id;
        if (is_null($for_language))
            $for_language = $languages_id;

        $code = strtolower(DEFAULT_LANGUAGE);
        if ( $strict ) $code = false;

        foreach (self::get_all() as $_info) {
            if (is_numeric($for_language) && (int) $_info['id'] == (int) $for_language) {
                $code = $_info['code'];
                break;
            } elseif (!is_numeric($for_language) && $_info['directory'] == $for_language) {
                $code = $_info['code'];
                break;
            }
        }

        return $code;
    }

}
