<?php
/**
 * This file is part of True Loaded.
 * 
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 * 
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\helpers;

class Country {

    public static function get_countries($countries_id = '', $with_iso_codes = false, $default = '', $type = '') {
        $countries_array = array();
        $first = 0;
        if ($default) {
            $countries_array[] = array(
                'id' => '',
                'text' => $default
            );
            $first = 1;
        }
        if (!empty($countries_id)) {
            if ($with_iso_codes == true) {
                $countries = tep_db_query("select countries_id, countries_name, countries_iso_code_2, countries_iso_code_3 from " . TABLE_COUNTRIES . " where countries_id = '" . (int) $countries_id . "' order by countries_name");
                $countries_values = tep_db_fetch_array($countries);
                if (!is_array($countries_values)) {
                    $countries_values = array(
                        'countries_id' => $countries_id,
                        'countries_name' => 'Unknown',
                        'countries_iso_code_2' => "$countries_id",
                        'countries_iso_code_3' => "$countries_id"
                    );
                }
                $countries_array = array(
                    'id' => $countries_values['countries_id'],
                    'text' => $countries_values['countries_name'],
                    'countries_name' => $countries_values['countries_name'],
                    'countries_iso_code_2' => $countries_values['countries_iso_code_2'],
                    'countries_iso_code_3' => $countries_values['countries_iso_code_3'],
                );
            } else {
                $countries = tep_db_query("select countries_name from " . TABLE_COUNTRIES . " where countries_id = '" . (int) $countries_id . "' ");
                $countries_values = tep_db_fetch_array($countries);
                $countries_array = array('countries_name' => $countries_values['countries_name']);
            }
        } else {
            $countries = tep_db_query("select countries_id, countries_name from " . TABLE_COUNTRIES . " where 1 order by countries_name");
            while ($countries_values = tep_db_fetch_array($countries)) {
                $country = array(
                    'id' => $countries_values['countries_id'],
                    'text' => $countries_values['countries_name'],
                    'countries_id' => $countries_values['countries_id'],
                    'countries_name' => $countries_values['countries_name']
                );
                $countries_array[] = $country;
            }
        }

        return $countries_array;
    }

    public static function get_country_id($country_name) {

        $country_id_query = tep_db_query("select * from " . TABLE_COUNTRIES . " where countries_name = '" . tep_db_input($country_name) . "'");

        if (!tep_db_num_rows($country_id_query)) {
            return 0;
        } else {
            $country_id_row = tep_db_fetch_array($country_id_query);
            return $country_id_row['countries_id'];
        }
    }

    public static function get_country_name($country_id) {
        $country_query = tep_db_query("select countries_name from " . TABLE_COUNTRIES . " where countries_id = '" . (int) $country_id . "'");
        if (!tep_db_num_rows($country_query)) {
            return $country_id;
        } else {
            $country = tep_db_fetch_array($country_query);
            return $country['countries_name'];
        }
    }

    public static function get_country_info_by_id($country_id) {
        $country_array = self::get_countries($country_id, true);
        return $country_array;
    }

    public static function get_country_info_by_name($country_name) {
        $res = tep_db_query("select * from " . TABLE_COUNTRIES . " where countries_name = '" . tep_db_input($country_name) . "'");
        $ret = array();

        if ($d = tep_db_fetch_array($res)) {
            $ret = array('id' => $d['countries_id'],
                'title' => $d['countries_name'],
                'iso_code_2' => $d['countries_iso_code_2'],
                'iso_code_3' => $d['countries_iso_code_3'],
            );
        } else {
            $res = tep_db_query("select * from " . TABLE_COUNTRIES . " where soundex(countries_name) = soundex('" . tep_db_input($country_name) . "') or countries_iso_code_2 like '" . preg_replace("/\W/", "", tep_db_input($country_name)) . "' or countries_iso_code_3 like '" . preg_replace("/\W/", "", tep_db_input($country_name)) . "'");
            if ($d = tep_db_fetch_array($res)) {
                $ret = array('id' => $d['countries_id'],
                    'title' => $d['countries_name'],
                    'iso_code_2' => $d['countries_iso_code_2'],
                    'iso_code_3' => $d['countries_iso_code_3'],
                );
            } else {
                $ret = $country_name;
            }
        }


        return $ret;
    }

}
