<?php
/**
 * This file is part of True Loaded.
 * 
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 * 
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\helpers;

class Init {

    public static function getPrefixFull() {
       return defined('STORE_NAME') ? STORE_NAME: \Yii::$app->name;
    }
    
    public static function getCurrentSecureKey() {
        $row = \common\models\IoProject::find()->one();
        return isset($row->access_token) ? $row->access_token : null;
    }

    public static function getCurrentSecureKeyCheck() {
        $key = self::getCurrentSecureKey();
        if (is_null($key)) {
            // dance)
            self::IOInit();
            $key = self::getCurrentSecureKey();
            if (is_null($key)) {
                die('Migration was not performed correctly');
            }
        }
        return $key;
    }

    public static function checkSecureKey($key)
    {
        return self::getCurrentSecureKeyCheck() === $key;
    }

    public static function generateToken()
    {
        $prefix = \common\helpers\Init::getPrefixFull();
        return str_replace('.', '', strtoupper(substr(preg_replace('/[^\da-z]/i', '', $prefix), 0, 4) . '_' . date('ymd') . uniqid('', true). uniqid('', true). uniqid('', true)));
    }

    public static function deleteAllProjects()
    {
        if (\Yii::$app->db->schema->getTableSchema('io_project') !== null) {
            \common\models\IoProject::deleteAll();
        }
    }

    public static function IOInit() {
        $migrate = new \yii\db\Migration();
        $migrate->compact = true;

        $migrate->execute("
            CREATE TABLE IF NOT EXISTS io_project (
              project_id INT(11) NOT NULL AUTO_INCREMENT,
              project_code VARCHAR(32) NOT NULL,
              access_token VARCHAR(256),
              is_local TINYINT(1) NOT NULL DEFAULT 0,
              department_id INT(11) NOT NULL DEFAULT 0,
              platform_id INT(11) NOT NULL DEFAULT 0,
              description VARCHAR(255) NOT NULL DEFAULT '',
              PRIMARY KEY(project_id),
              UNIQUE KEY(project_code)
            ) ENGINE=InnoDB CHARSET=UTF8
        ");

        if ($migrate->db->getTableSchema('io_project', true)->getColumn('access_token') === null) {
            $migrate->addColumn('io_project', 'access_token', 'VARCHAR(256) after project_code');
            $projects = \common\models\IoProject::find()->select('project_id, access_token')->all();
            foreach( $projects as $project) {
                if (empty($project->access_token)) {
                    \common\models\IoProject::updateAll(['access_token' => self::generateToken() ], 'project_id='.$project->project_id);
                }
            }
        }

        $migrate->execute("
            CREATE TABLE IF NOT EXISTS io_entity (
              id INT(11) NOT NULL AUTO_INCREMENT,
              project_id INT(11) NOT NULL,
              entity_name VARCHAR(128) NOT NULL,
              PRIMARY KEY(id),
              KEY(project_id),
              KEY(entity_name(24))
            ) ENGINE=InnoDB CHARSET=UTF8
        ");

        $migrate->execute("
            CREATE TABLE IF NOT EXISTS io_entity_mapping (
              entity_id INT(11) NOT NULL,
              external_id INT(11) NOT NULL,
              internal_id INT(11) NOT NULL,
              UNIQUE KEY(entity_id, external_id, internal_id)
            ) ENGINE=InnoDB CHARSET=UTF8
        ");

        \common\api\models\XML\Project::checkLocalProjects();
    }


}