<?php
/**
 * This file is part of True Loaded.
 * 
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 * 
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\models;

use Yii;
use yii\db\ActiveRecord;
use common\models\Orders;
use yii\db\Query;
use yii\helpers\ArrayHelper;


/**
 * This is the model class for table "customers".
 *
 * @property int $customers_id
 * @property string $customers_gender
 * @property string $customers_firstname
 * @property string $customers_lastname
 * @property string $customers_dob
 * @property string $customers_email_address
 * @property int $platform_id
 * @property int $customers_default_address_id
 * @property string $customers_telephone
 * @property string $customers_landline
 * @property string $customers_fax
 * @property string $customers_password
 * @property string $customers_newsletter
 * @property string $customers_selected_template
 * @property int $admin_id
 * @property string $customers_alt_email_address
 * @property string $customers_alt_telephone
 * @property string $customers_cell
 * @property int $customers_owc_member
 * @property int $customers_type_id
 * @property int $customers_bonus_points
 * @property string $customers_credit_avail
 * @property int $affiliate_id
 * @property int $groups_id
 * @property int $customers_status
 * @property string $last_xml_import
 * @property string $last_xml_export
 * @property int $opc_temp_account
 * @property string $customers_company
 * @property string $customers_company_vat
 * @property string $credit_amount
 * @property int $sap_servers_id
 * @property int $customers_currency_id
 * @property string $customers_cardcode
 * @property int $currency_switcher
 * @property int $erp_customer_id
 * @property string $erp_customer_code
 * @property int $trustpilot_disabled
 */
class Customers extends ActiveRecord
{

    /**
     * set table name
     * @return string
     */
    public static function tableName()
    {
        return 'customers';
    }


    public function getAddressBooks(){
        return $this->hasMany(AddressBook::className(), ['customers_id' => 'customers_id']);
    }

    public function init() {
        parent::init();
    }

    public function getCustomersInfo(){
        return $this->hasOne(CustomersInfo::className(), ['customers_info_id' => 'customers_id']);
    }

    public function getOrders()
    {
        return $this->hasMany(Orders::className(), ['customers_id' => 'customers_id']);
    }
    
    public function getDefaultAddress(){
    	return $this->hasOne(AddressBook::className(), ['address_book_id' => 'customers_default_address_id']);
    }
}