<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\models;

use Yii;
use yii\db\ActiveRecord;

class Groups extends ActiveRecord
{
    /**
     * set table name
     * @return string
     */
    public static function tableName()
    {
        return 'groups';
    }
    /**
     * one-to-many
     * @return object
     */
    public function getAdditionalDiscounts()
    {
        return $this->hasMany(GroupsDiscounts::className(), ['groups_id' => 'groups_id'])->orderBy('groups_discounts_amount');
    }
    
    public function getAdditionalDiscountsCS()
    {
        return $this->hasMany(GroupsDiscounts::className(), ['groups_id' => 'groups_id'])->where('check_supersum = 1')->orderBy('groups_discounts_amount');
    }
    
    public function getAdditionalDiscountsNCS()
    {
        return $this->hasMany(GroupsDiscounts::className(), ['groups_id' => 'groups_id'])->where('check_supersum = 0')->orderBy('groups_discounts_amount');
    }    
}