<?php

namespace common\models;

use Yii;
use yii\helpers\Html;
/**
 * This is the model class for table "languages".
 *
 * @property integer $languages_id
 * @property string $name
 * @property string $code
 * @property string $image
 * @property string $image_svg
 * @property string $directory
 * @property integer $sort_order
 * @property integer $languages_status
 * @property string $locale
 * @property integer $shown_language
 * @property integer $searchable_language
 *
 */
class Languages extends \yii\db\ActiveRecord
{
    public $logo = '';
    public $svgSrc = '';
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'languages';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'code'], 'required'],
            [['sort_order', 'languages_status', 'shown_language', 'searchable_language'], 'integer'],
            [['name', 'directory'], 'string', 'max' => 32],
            [['code'], 'string', 'max' => 2],
            [['image', 'image_svg'], 'string', 'max' => 64],
            [['locale'], 'string', 'max' => 10],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'languages_id' => 'Languages ID',
            'name' => 'Name',
            'code' => 'Code',
            'image' => 'Image',
            'image_svg' => 'Image Svg',
            'directory' => 'Directory',
            'sort_order' => 'Sort Order',
            'languages_status' => 'Languages Status',
            'locale' => 'Locale',
            'shown_language' => 'Shown Language',
            'searchable_language' => 'Searchable Language',
        ];
    }

}
