<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\models;

use Yii;
use yii\db\ActiveRecord;


class OrdersProducts extends ActiveRecord
{
    /**
     * set table name
     * @return string
     */
    public static function tableName()
    {
        return 'orders_products';
    }

    public function getOrdersProductsAttributes()
    {
        return $this->hasMany(OrdersProductsAttributes::className(), ['orders_products_id' => 'orders_products_id', 'orders_id'=>'orders_id']);
    }

    /*
     * one-to-one
     * @return object
     */
    public function getOrder()
    {
        return $this->hasOne(Orders::className(), ['orders_id' => 'orders_id']);
    }

    /*
     * one-to-one
     * @return object
     */
    public function getProduct()
    {
        return $this->hasOne(Products::className(), ['products_id' => 'products_id']);
    }

    /*
     * one-to-one
     * @return object
     */
    public function getInventory()
    {
        return $this->hasOne(Inventory::className(), ['products_id' => 'uprid']);
    }

    /*
     * one-to-one
     * @return object
     */
    public function getSuppliersProduct()
    {
        return $this->hasOne(SuppliersProducts::className(), ['uprid' => 'uprid']);
    }

    public function getUpsell(){
		return $this->hasMany(ProductsUpsell::className(),['products_id' => 'products_id']);
    }

    public function getXsell(){
	    return $this->hasMany(ProductsXsell::className(),['products_id' => 'products_id']);
    }
}
