<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\models;

use Yii;
use yii\db\ActiveRecord;


/**
 * This is the model class for table "orders_status".
 *
 * @property int $orders_status_id
 * @property int $orders_status_groups_id
 * @property int $language_id
 * @property string $orders_status_name
 * @property string $orders_status_template
 * @property int $automated
 */
class OrdersStatus extends ActiveRecord
{
    /**
     * set table name
     * @return string
     */
    public static function tableName()
    {
        return 'orders_status';
    }

    public static function create($orders_status_id, $orders_status_groups_id, $language_id, $orders_status_name, $orders_status_template, $automated){
    	$model = new static();
    	$model->orders_status_id = $orders_status_id;
    	$model->orders_status_groups_id = $orders_status_groups_id;
    	$model->language_id = $language_id;
    	$model->orders_status_name = $orders_status_name;
    	$model->orders_status_template = $orders_status_template;
    	$model->automated = $automated;
    	return $model;
    }

    public static function newOrdersStatusId(){
    	return self::find()->max('orders_status_id') + 1;
    }
}
