<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\models;

use Yii;
use yii\db\ActiveRecord;
use yii\behaviors\TimestampBehavior;



/**
 * This is the model class for table "orders_status_history".
 *
 * @property int $orders_status_history_id
 * @property int $orders_id
 * @property int $orders_status_id
 * @property string $date_added
 * @property int $customer_notified
 * @property string $comments
 * @property int $admin_id
 * @property string $smscomments
 */
class OrdersStatusHistory extends ActiveRecord
{
    /**
     * set table name
     * @return string
     */
    public static function tableName()
    {
        return 'orders_status_history';
    }


	public function behaviors() {
		return [
			[
				'class' => TimestampBehavior::className(),
				'attributes' => [
					ActiveRecord::EVENT_BEFORE_INSERT => ['date_added'],
				],
				'value' => new \yii\db\Expression('NOW()'),
			]
		];
    }

    public function getOrder(){
	    return $this->hasOne(Orders::className(), ['orders_id' => 'orders_id']);
    }

    public static function create($orders_id, $orders_status_id, $customer_notified = 0, $comments = '', $admin_id = 0, $smscomments = ''){
    	$raw = new static();
    	$raw->orders_id = $orders_id;
    	$raw->orders_status_id = $orders_status_id;
    	$raw->customer_notified = $customer_notified;
    	$raw->comments = $comments;
    	$raw->admin_id = $admin_id;
    	$raw->smscomments = $smscomments;
    	return $raw;
    }
}
