<?php
/**
 * This file is part of True Loaded.
 * 
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 * 
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\models;


/**
 * This is the model class for table "products".
 *
 * @property int $products_id
 */

class Products extends \yii\db\ActiveRecord
{
    /**
     * set table name
     * @return string
     */
    public static function tableName()
    {
        return 'products';
    }

    /**
     * one-to-many
     * @return array
     */
    public function getDescriptions()
    {
        return $this->hasMany(ProductsDescription::className(), ['products_id' => 'products_id']);
    }

    public function getDescription(){
    	global $languages_id;
	    return $this->hasOne(ProductsDescription::className(), ['products_id' => 'products_id'])->where(['language_id' => $languages_id]);
    }

    /**
     * one-to-many
     * @return array
     */
    public function getCategoriesList()
    {
        return $this->hasMany(Products2Categories::className(), ['products_id' => 'products_id']);
    }

    public function getProductsPrices()
    {
        return $this->hasMany(ProductsPrices::className(), ['products_id' => 'products_id']);
    }

    public function getProductsAttributes()
    {
        return $this->hasMany(ProductsAttributes::className(), ['products_id' => 'products_id']);
    }

    public function getProductsFeatured()
    {
        return $this->hasMany(ProductsFeatured::className(), ['products_id' => 'products_id']);
    }

    public function getProductImagesList()
    {
        return $this->hasMany(ProductsImages::className(), ['products_id' => 'products_id']);
    }
    /**
     * one-to-many
     * @return array
     */
    public function getInventories()
    {
        return $this->hasMany(Inventory::className(), ['prid' => 'products_id']);
    }

    /**
     * one-to-many
     * @return array
     */
    /*
    public function getPrices($customer_groups_id = 0, $currency_id = 0)
    {
        return $this->hasOne(ProductsPrices::className(), ['products_id' => 'products_id'])->where('group1s_id =:groups_id', [':groups_id' => $customer_groups_id])->andWhere('currencies_id = :currencies_id', [':currencies_id' => $currency_id]);
    }*/
}