<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

namespace common\models;

use Yii;
use yii\db\ActiveQuery;
use yii\db\ActiveRecord;

class ProductsOptions extends ActiveRecord
{
    /**
     * set table name
     * @return string
     */
    public static function tableName()
    {
        return 'products_options';
    }

    public function getAssignedValuesIds()
    {
        return $this->hasMany(ProductsOptions2ProductsOptionsValues::className(), ['products_options_id' => 'products_options_id']);
    }

    /**
     * many-to-many
     * @return array
     */
    public function getValues()
    {
        return $this->hasMany(ProductsOptionsValues::className(), ['products_options_values_id' => 'products_options_values_id'])->andOnCondition(['language_id' => $this->language_id])->via('assignedValuesIds');
        /*
        return $this->hasMany(ProductsOptionsValues::class, ['products_options_values_id' => 'products_options_values_id'])
                ->andOnCondition(['language_id' => $this->language_id])
                ->viaTable('products_options_values_to_products_options', ['products_options_id' => 'products_options_id']);
        */
    }

    /**
     * @return ActiveQuery
     */
    public function findIds()
    {
        return static::find()->distinct()->select('products_options_id')->orderBy('products_options_id');
    }

    /*
    public function getTexts()
    {
        return $this->hasMany(ProductsOptions::className(), ['products_options_id' => 'products_options_id']);
    }
    */

    public function beforeDelete()
    {
        if (!parent::beforeDelete())
        {
            return false;
        }

        /*ProductsOptions2ProductsOptionsValues::deleteAll(
            'products_options_id=:products_options_id',
            [':products_options_id' => $this->products_options_id]
        );*/

        return true;
    }


}