<?php

namespace common\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "tax_rates".
 *
 * @property integer $tax_rates_id
 * @property integer $tax_zone_id
 * @property integer $tax_class_id
 * @property integer $tax_priority
 * @property string $tax_rate
 * @property string $tax_description
 * @property string $last_modified
 * @property string $date_added
 * @property string $tax_type
 */
class TaxRates extends ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'tax_rates';
    }

    public function getTaxZone()
    {
        return $this->hasOne(TaxZones::className(), ['geo_zone_id' => 'tax_zone_id']);
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['tax_zone_id', 'tax_class_id', 'tax_priority'], 'integer'],
            [['tax_rate'], 'number'],
            [['tax_description', 'tax_type'], 'required'],
            [['last_modified', 'date_added'], 'safe'],
            [['tax_description'], 'string', 'max' => 255],
            [['tax_type'], 'string', 'max' => 1]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'tax_rates_id' => 'Tax Rates ID',
            'tax_zone_id' => 'Tax Zone ID',
            'tax_class_id' => 'Tax Class ID',
            'tax_priority' => 'Tax Priority',
            'tax_rate' => 'Tax Rate',
            'tax_description' => 'Tax Description',
            'last_modified' => 'Last Modified',
            'date_added' => 'Date Added',
            'tax_type' => 'Tax Type',
        ];
    }
}
