<?php

namespace common\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "tax_zones".
 *
 * @property integer $geo_zone_id
 * @property string $geo_zone_name
 * @property string $geo_zone_description
 * @property string $last_modified
 * @property string $date_added
 */
class TaxZones extends ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'geo_zones';
    }


    public function getZoneZones()
    {
        return $this->hasMany(TaxZonesZones::className(), ['geo_zone_id' => 'geo_zone_id']);
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['geo_zone_name', 'geo_zone_description'], 'required'],
            [['last_modified', 'date_added'], 'safe'],
            [['geo_zone_name'], 'string', 'max' => 32],
            [['geo_zone_description'], 'string', 'max' => 255]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'geo_zone_id' => 'Geo Zone ID',
            'geo_zone_name' => 'Geo Zone Name',
            'geo_zone_description' => 'Geo Zone Description',
            'last_modified' => 'Last Modified',
            'date_added' => 'Date Added',
        ];
    }
}
