<?php
/**
 * This file is part of True Loaded.
 * 
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 * 
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

// uncomment below line to allow create secure file via web browser
//define('ALLOW_TO_CREATE_SECURE_FILE', TRUE);

// you can specify full path to configure.php if it is not found automatically.
// For example:
// $configure_filename = '/home/user_name/public_html/catalog/includes/configure.php';
// or
// $configure_filename = dirname(__DIR__) . '/../catalog/includes/configure.php';
$configure_fullpath = '';

$probably_files = !empty($configure_fullpath) ? array($configure_fullpath) :
    array(
        dirname(__DIR__) . '/../catalog/includes/local/configure.php',
        dirname(__DIR__) . '/../catalog/includes/configure.php',
        dirname(__DIR__) . '/../includes/local/configure.php',
        dirname(__DIR__) . '/../includes/configure.php',
    );

$configure_filename = '';
foreach ($probably_files as $config_file) {
    if (!empty($config_file) && file_exists($config_file)) {
        $configure_filename = $config_file;
        break;
    }
}

if (empty($configure_filename)) {
    die('File configure.php is not found. See Troubleshooting section in readme file.');
}

if ($configure_filename) {
    $configure_content = implode('', file($configure_filename));
    if (!$configure_content) die("File $configure_filename is found but is empty or unreadable");

    $keys_array = [
        'DB_SERVER',
        'DB_SERVER_USERNAME',
        'DB_SERVER_PASSWORD',
        'DB_DATABASE',
        'HTTP_SERVER',
        'DIR_WS_HTTP_CATALOG',
        'HTTPS_SERVER',
        'DIR_WS_HTTPS_CATALOG',
        'DIR_FS_CATALOG',
    ];
    $parseMsg = '';
    foreach ($keys_array as $key) {
        if (preg_match("/^\s*define\('" . preg_quote($key, '/') . "', ?'([^']+)'\)/m", $configure_content, $reg)) {
            if ($reg[1]) {
                defined($key) or define($key, $reg[1]);
            } else {
                $parseMsg .= "Key $key found but not value\n";
            }
        } else {
            $parseMsg .= "Key $key not found\n";
        }
    }
    if (defined('HTTPS_SERVER') && !defined('HTTP_SERVER')) {
        define('HTTP_SERVER', HTTPS_SERVER);
    }
    if (defined('DIR_WS_HTTPS_CATALOG') && !defined('DIR_WS_HTTP_CATALOG')) {
        define('DIR_WS_HTTP_CATALOG', DIR_WS_HTTPS_CATALOG);
    }
    if (defined('HTTPS_SERVER') && defined('DIR_WS_HTTPS_CATALOG')) {
        define('CATALOG_URL', HTTPS_SERVER . DIR_WS_HTTPS_CATALOG);
    } elseif (defined('HTTP_SERVER') && defined('DIR_WS_HTTP_CATALOG')) {
        define('CATALOG_URL', HTTP_SERVER . DIR_WS_HTTP_CATALOG);
    }

    // check
    if (($key = array_search('DIR_FS_CATALOG', $keys_array)) !== false) {
        unset($keys_array[$key]);
    }
    $notDefined = array_filter($keys_array, function ($value) { return !defined($value); } );
    if (!empty($notDefined)) {
        die(nl2br("Not all configure constant are found:\n" . implode(',', $notDefined) . "\n" . $parseMsg));
    }
}

if (!defined('DB_DATABASE') || !DB_DATABASE) {
    die("File $configure_filename is found but DB_DATABASE is empty. See Troubleshooting section in readme file.");
} 

// define our database connection
if (!defined('HTTPS_SERVER')) define('DB_SERVER', 'localhost'); // eg, localhost - should not be empty for productive servers
if (!defined('DB_SERVER_USERNAME')) define('DB_SERVER_USERNAME', '');
if (!defined('DB_SERVER_PASSWORD')) define('DB_SERVER_PASSWORD', '');
if (!defined('DB_DATABASE')) define('DB_DATABASE', '');
if (!defined('USE_PCONNECT')) define('USE_PCONNECT', 'false'); // use persistent connections?
if (!defined('STORE_SESSIONS')) define('STORE_SESSIONS', 'mysql'); // leave empty '' for default handler or set to 'mysql'

if (!defined('CATALOG_URL')) define('CATALOG_URL', 'https://localhost/');
if (!defined('DIR_FS_CATALOG')) define('DIR_FS_CATALOG', realpath(dirname(__DIR__) . '/..') . '/');

define('OSCB_VER', '1.59');
//define('DEFAULT_LANGUAGE', 'en');
//define('STORE_NAME', 'test');