<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use app\models\LoginForm;
use app\models\ContactForm;
use common\api\models\XML\IOCore;
use common\api\models\XML\Project;

class SiteController extends Controller
{
    public $enableCsrfValidation = false;
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    public function init()
    {
        parent::init();
        \Yii::$app->user->enableSession = false;
        \common\helpers\Init::IOInit();
    }

    /**
     * Displays homepage.
     *
     * @return string
     */
    public function actionIndex()
    {
        $this->checkAuth();
        $feed = Yii::$app->request->get('feed');
        try {
            set_time_limit(0);
            //$structure = 'products_options';
            //$structure = 'products';
            $structure = $feed;
            //$structure = 'tax_zones';
            $exportC = [$structure];

            \common\api\models\XML\IOCore::get()->setAttachmentMode(['attach_file', 'file_info', 'url', 'checksum_md5', 'checksum_sha1']);

            foreach ($exportC as $structure) {
                $exportStructure = \common\api\models\XML\IOCore::getExportStructure($structure);
                if ($exportStructure) {
                    header('Content-type: text/xml');
                    //$exportToFile = 'xml/' . $structure . '.xml';
                    $exportToFile = 'php://output';
                    $IOProject = new \common\api\models\XML\Project($exportToFile);
                    $IOProject->setStructure($exportStructure);
                    $IOProject->setPage(Yii::$app->request->get('offset'), Yii::$app->request->get('limit'));

                    $IOProject->export();

                    if (count($exportC) == 1) {
                        if ($exportToFile != 'php://output') {
                            readfile($exportToFile);
                        }
                    } else {
                        \Yii::warning("count(exportC) != 1\n structure=".var_export($structure, true)."\n filesize=".filesize($exportToFile));
                    }
                }
            }
        } catch (\Exception $ex) {
            \Yii::error($ex->getMessage(). "\n".$ex->getTraceAsString());
        }
        exit;
    }

    private function getLogInfo()
    {
        $logs = [];

        if (is_array(\Yii::$app->getLog()->targets)) {
            foreach (\Yii::$app->getLog()->targets as $logObj) {
                if ($logObj instanceof \yii\log\FileTarget) {
                    $logs[] = [
                        'filename'      => $logObj->logFile,
                        'exists'        => @file_exists($logObj->logFile),
                        'filesize'      => @filesize($logObj->logFile),
                        'datetime'      => @filemtime($logObj->logFile), //date("Y-m-d H:i:s.", filemtime($filename)),
                    ];
                }
            }
        }
        return $logs;
    }


    public function actionStatus()
    {
        $this->checkAuth();
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        return [
            'version' => OSCB_VER,
            'count_order_status' => \common\models\OrdersStatus::find()->count(),
            'logs' => $this->getLogInfo(),
        ];
    }

    public function actionCount()
    {
        $this->checkAuth();
        Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        try {
            $feed = Yii::$app->request->get('feed');
            $exportStructure = \common\api\models\XML\IOCore::getExportStructure($feed);
            if ($exportStructure) {
                foreach ($exportStructure['Data'] as $model => $value)
                    break;
                $tableName = $model::tableName();
                if (!\Yii::$app->db->schema->getTableSchema($tableName)) {
                    throw new \Exception("Module is not installed: table $tableName does not exist");
                }
                $count = $model::find()->count();
                return ['count' => $count];
            }
        } catch(\Exception $e) {
            return ['count' => -1, 'error' => $e->getMessage()];
        }
    }


    /**
     * Login action.
     *
     * @return Response|string
     */
    public function actionLogin()
    {
/*
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->goBack();
        }

        $model->password = '';
        return $this->render('login', [
            'model' => $model,
        ]);
*/
    }

    /**
     * Logout action.
     *
     * @return Response
     */
    public function actionLogout()
    {
/*
        Yii::$app->user->logout();

        return $this->goHome();
*/
    }

    /**
     * Displays contact page.
     *
     * @return Response|string
     */
    public function actionContact()
    {
/*
        $model = new ContactForm();
        if ($model->load(Yii::$app->request->post()) && $model->contact(Yii::$app->params['adminEmail'])) {
            Yii::$app->session->setFlash('contactFormSubmitted');

            return $this->refresh();
        }
        return $this->render('contact', [
            'model' => $model,
        ]);
*/
    }

    /**
     * Displays about page.
     *
     * @return string
     */
    public function actionAbout()
    {
//        return $this->render('about');
    }

    public function actionCreateSecFile()
    {
        if (defined('ALLOW_TO_CREATE_SECURE_FILE') && ALLOW_TO_CREATE_SECURE_FILE==TRUE) {
            $uuid =  'SECFILE_' . uniqid('', true).uniqid('', true);
            $key = \common\helpers\Init::getCurrentSecureKeyCheck();
            file_put_contents(dirname(__DIR__) . DIRECTORY_SEPARATOR . $uuid, 'The secure key is '.$key."\n\nPlease store the key and delete this file for security reason")
                or die("Unable to write file!");
            echo "File was created successfully";
        } else {
            header('HTTP/1.0 403 Forbidden');
            echo 'The action is forbidden. Please check readme file for details.';
        }
        exit;
    }

    private function checkSecureKey($key)
    {
        if (!\common\helpers\Init::checkSecureKey($key))
            $this->errorAuth($key);
    }

    private function getAuthStr()
    {
        $s = \Yii::$app->request->getHeaders()->get('Authorization');
        if (empty($s))
            $s = \Yii::$app->request->getHeaders()->get('HTTP_AUTHORIZATION');

        return $s;
    }


    private function extractSecureKey()
    {
        $res = null;
        $bearer = $this->getAuthStr();
        if (!empty($bearer) && preg_match('/^Bearer\s+(.*?)$/', $bearer, $res)) {
            Yii::debug('Auth=Bearer: '.$res[1], 'auth');
            return $res[1];
        }
        $res = \Yii::$app->request->post('key');
        if (\Yii::$app->request->isPost && !empty($res)) {
            Yii::debug('Auth=POST: '.$res, 'auth');
            return $res;
        }
        $res = \Yii::$app->request->get('key');
        if (\Yii::$app->request->isGet && !empty($res)) {
            Yii::debug('Auth=GET: '.$res, 'auth');
            return $res;
        }
        Yii::debug('Auth=none', 'auth');
    }

    private function errorAuth($key=null)
    {
//        throw new \yii\web\UnauthorizedHttpException('Please check Authorization topic in readme file.');
        header('HTTP/1.1 401 Unauthorized');
        echo 'Please check Authorization topic in readme file.';
//        trigger_error("ZERO DIVIDE", E_USER_NOTICE);
        die;
    }

    private function checkAuth()
    {
        $key = $this->extractSecureKey();
        if (empty($key)) {
            $this->errorAuth();
        } else {
            $this->checkSecureKey($key);
        }
    }
}
