<?php

use yii\db\Migration;
use yii\db\Schema;

/**
 * Class m180403_134513_io_init
 */
class m180403_134513_io_init extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->execute("
            CREATE TABLE IF NOT EXISTS io_project (
              project_id INT(11) NOT NULL AUTO_INCREMENT,
              project_code VARCHAR(32) NOT NULL,
              is_local TINYINT(1) NOT NULL DEFAULT 0,
              department_id INT(11) NOT NULL DEFAULT 0,
              platform_id INT(11) NOT NULL DEFAULT 0,
              description VARCHAR(255) NOT NULL DEFAULT '',
              PRIMARY KEY(project_id),
              UNIQUE KEY(project_code)
            ) ENGINE=InnoDB CHARSET=UTF8
        ");
        $this->execute("
            CREATE TABLE IF NOT EXISTS io_entity (
              id INT(11) NOT NULL AUTO_INCREMENT,
              project_id INT(11) NOT NULL,
              entity_name VARCHAR(128) NOT NULL,
              PRIMARY KEY(id),
              KEY(project_id),
              KEY(entity_name(24))
            ) ENGINE=InnoDB CHARSET=UTF8
        ");

        $this->execute("
            CREATE TABLE IF NOT EXISTS io_entity_mapping (
              entity_id INT(11) NOT NULL,
              external_id INT(11) NOT NULL,
              internal_id INT(11) NOT NULL,
              UNIQUE KEY(entity_id, external_id, internal_id)
            ) ENGINE=InnoDB CHARSET=UTF8
        ");

        \common\api\models\XML\Project::checkLocalProjects();
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('io_project');
        $this->dropTable('io_entity');
        $this->dropTable('io_entity_mapping');
    }

    /*
    // Use up()/down() to run migration code without a transaction.
    public function up()
    {

    }

    public function down()
    {
        echo "m180403_134513_io_init cannot be reverted.\n";

        return false;
    }
    */
}
